/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.steps;

import filenet.vw.api.VWStepDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.steps.VWCasePropertySelectionPanel;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.resources.VWResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

class VWCasePropertySelectionDialog
extends VWModalDialog
implements ActionListener {
    private VWCasePropertySelectionPanel m_casePropertiesPanel = null;
    private JButton m_okButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;
    private VWAuthPropertyData m_authPropertyData = null;

    public VWCasePropertySelectionDialog(Frame parentFrame, VWAuthPropertyData authPropertyData) {
        super(parentFrame);
        this.m_authPropertyData = authPropertyData;
        this.layoutControls();
    }

    public void initialize(VWStepDefinition stepDefinition) {
        if (this.m_casePropertiesPanel != null) {
            this.m_casePropertiesPanel.initialize(this.m_authPropertyData, stepDefinition);
        }
        this.m_nExitStatus = 1;
    }

    public void releaseReferences() {
        if (this.m_casePropertiesPanel != null) {
            this.m_casePropertiesPanel.removeReferences();
            this.m_casePropertiesPanel = null;
        }
        if (this.m_okButton != null) {
            this.m_okButton.removeActionListener(this);
            this.m_okButton = null;
        }
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this);
            this.m_cancelButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this);
            this.m_helpButton = null;
        }
        super.removeReferences();
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getSource() == this.m_okButton) {
                this.m_casePropertiesPanel.createParameters();
                this.m_nExitStatus = 0;
                this.setVisible(false);
            } else if (event.getSource() == this.m_cancelButton) {
                this.setVisible(false);
            } else if (event.getSource() == this.m_helpButton) {
                VWHelp.displayPage(VWHelp.Help_Process_Designer + "bpfdh067.htm");
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this, ex.getLocalizedMessage(), 1);
        }
    }

    private void layoutControls() {
        try {
            Dimension dim = new Dimension(600, 350);
            this.setSize(dim);
            this.getContentPane().setLayout(new BorderLayout(6, 6));
            this.setTitle(VWResource.s_propertySelection);
            this.setVisible(false);
            this.initializeContentPane();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void initializeContentPane() {
        try {
            this.m_casePropertiesPanel = new VWCasePropertySelectionPanel(this);
            this.getContentPane().add((Component)this.m_casePropertiesPanel, "Center");
            this.getContentPane().add((Component)this.createButtonPanel(), "Last");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel createButtonPanel() {
        try {
            JPanel buttonPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 10;
            gbCons.fill = 0;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(6, 6, 6, 6);
            this.m_okButton = new JButton(VWResource.s_ok);
            this.m_okButton.setName("m_okButton_VWCasePropertySelectionDialog");
            this.m_okButton.addActionListener(this);
            buttonPanel.add((Component)this.m_okButton, gbCons);
            ++gbCons.gridx;
            this.m_cancelButton = new JButton(VWResource.s_cancel);
            this.m_cancelButton.setName("m_cancelButton_VWCasePropertySelectionDialog");
            this.m_cancelButton.addActionListener(this);
            buttonPanel.add((Component)this.m_cancelButton, gbCons);
            ++gbCons.gridx;
            this.m_helpButton = new JButton(VWResource.s_help);
            this.m_helpButton.setName("m_helpButton_VWCasePropertySelectionDialog");
            this.m_helpButton.addActionListener(this);
            buttonPanel.add((Component)this.m_helpButton, gbCons);
            return buttonPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }
}

